

dofile(rootDir() .. "/framework.lua")
pattern = dofile(rootDir() .. "/pattern.lua")
local json = require("json")


function url_encode2(str)
    if str then
        str = str:gsub("\n", "\r\n")
        str = str:gsub("([^%w _%%%-%.~])",
            function(c) return string.format("%%%02X", string.byte(c)) end)
        str = str:gsub(" ", "%%20")
    end
    return str
end

-- Method GET  ------------------------------------------------------------------------------------------------------------------------
function SendRequest(url)
    -- Cách ĐẶC BIỆT HIỆU QUẢ cho tool Việt Nam
    local cmd = 'timeout 20 curl -s --connect-timeout 10 --max-time 20 "' .. url .. '"'
    local result = execute(cmd)
    
    if result == nil or result == "" or result:match("curl:") or result:match("timeout:") then
        log("Curl timeout hoặc lỗi mạng")
        return false
    end
    
    return result
end

function HTTPGet4(InHeader, Link)
    local curl = require("cURL")
    local easy = curl.easy()

    easy:setopt(curl.OPT_URL, Link)
    easy:setopt(curl.OPT_SSL_VERIFYPEER, false)
    easy:setopt(curl.OPT_SSL_VERIFYHOST, 0)
    easy:setopt(curl.OPT_HTTPHEADER, InHeader)

    -- 🔧 Timeout dài hơn để chờ server trả về OTP
    easy:setopt(curl.OPT_TIMEOUT, 20)           -- Tổng thời gian chờ (giây)
    easy:setopt(curl.OPT_CONNECTTIMEOUT, 20)    -- Thời gian chờ kết nối

    local response = {}
    local start_time = os.time()

    local success, error_message = pcall(function()
        easy:setopt(curl.OPT_WRITEFUNCTION, function(data)
            table.insert(response, data)
            return #data
        end)
        easy:perform()
    end)

    local elapsed = os.difftime(os.time(), start_time)
    easy:close()

    if not success then
        log("⚠️ CURL lỗi: " .. tostring(error_message) .. " (sau " .. elapsed .. "s)")
        return nil
    end

    local responseString = table.concat(response)
    log("⏱ Thời gian phản hồi: " .. elapsed .. " giây")

    if string.find(responseString, "Error") or responseString == "" then
        log("⚠️ Server trả về lỗi hoặc phản hồi trống.")
        return nil
    end

    return responseString
end


function HTTPGet4New(InHeader, Link)
    -- 🔧 Xây dựng lệnh curl với timeout
    local curlCommand = 'curl -s'
    
    -- Thêm header nếu có
    if InHeader then
        for k, v in pairs(InHeader) do
            curlCommand = curlCommand .. string.format(' -H "%s: %s"', k, v)
        end
    end

    -- Timeout kết nối & timeout tổng
    local connectTimeout = 10   -- giây
    local maxTime = 20          -- giây
    curlCommand = curlCommand .. string.format(' --connect-timeout %d --max-time %d %s', connectTimeout, maxTime, Link)

    local start_time = os.time()
    local response = {}

    local success, error_message = pcall(function()
        local handle = io.popen(curlCommand)
        local data = handle:read("*a")
        handle:close()
        table.insert(response, data)
    end)

    local elapsed = os.difftime(os.time(), start_time)

    if not success then
        log("⚠️ Lỗi khi chạy curl: " .. tostring(error_message) .. " (sau " .. elapsed .. "s)")
        return nil
    end

    local responseString = table.concat(response)
    log("⏱ Thời gian phản hồi: " .. elapsed .. " giây")

    if responseString == "" or string.find(responseString, "Error") then
        log("⚠️ Server trả về lỗi hoặc phản hồi trống.")
        return nil
    end

    return responseString
end

function HTTPGet4NewOPT(InHeader, Link)
    local curlCommand = 'curl -s'

    -- Header nếu muốn thêm, nhưng GET API này KHÔNG cần
    if InHeader then
        for k, v in pairs(InHeader) do
            curlCommand = curlCommand .. string.format(' -H "%s: %s"', k, v)
        end
    end

    -- Timeout kết nối & timeout tổng
    local connectTimeout = 10
    local maxTime = 20
    curlCommand = curlCommand .. string.format(' --connect-timeout %d --max-time %d "%s"', connectTimeout, maxTime, Link)

    local start_time = os.time()
    local response = {}

    local success, error_message = pcall(function()
        local handle = io.popen(curlCommand)
        local data = handle:read("*a") or ""
        handle:close()
        table.insert(response, data)
    end)

    local elapsed = os.difftime(os.time(), start_time)

    if not success then
        log("⚠️ Lỗi khi chạy curl: " .. tostring(error_message) .. " (sau " .. elapsed .. "s)")
        return nil
    end

    local responseString = table.concat(response)
    log("⏱ Thời gian phản hồi: " .. elapsed .. " giây")

    if responseString == "" or string.find(responseString, "Error") then
        log("⚠️ Server trả về lỗi hoặc phản hồi trống.")
        return nil
    end

    return responseString
end
-- Method POST  ------------------------------------------------------------------------------------------------------------------------
function HTTPPost4(InHeader, Link, Body)
    -- Ghép header thành chuỗi curl
    local header_cmd = ""
    for _, h in ipairs(InHeader) do
        header_cmd = header_cmd .. ' -H "' .. h .. '"'
    end

    -- Ghép body
    local body_cmd = ""
    if Body ~= nil then
        body_cmd = ' --data "' .. Body .. '"'
    end

    -- Curl command với timeout giống hàm SendRequest
    local cmd = 'curl -s --connect-timeout 5 --max-time 15' ..
                header_cmd ..
                body_cmd ..
                ' "' .. Link .. '"'

    -- Chạy curl
    local result = execute(cmd)

    -- Xử lý kết quả
    if result == nil or result == "" then
        log("⚠️ Không có kết quả POST")
        return false
    else
        log("📩 Kết quả POST: " .. result)
        return result
    end
end

-- function HTTPPost4(headers, url, body)
--     -- Ghép header (headers dạng: { ["Content-Type"] = "...", ["User-Agent"] = "..." })
--     local header_cmd = ""
--     if headers then
--         for k, v in pairs(headers) do
--             header_cmd = header_cmd .. ' -H "' .. k .. ': ' .. v .. '"'
--         end
--     end

--     -- Body
--     local body_cmd = ""
--     if body and body ~= "" then
--         body_cmd = ' --data "' .. body .. '"'
--     end

--     -- Curl command có timeout AN TOÀN như SendRequest()
--     local cmd =
--         'timeout 20 curl -s --connect-timeout 10 --max-time 20' ..
--         header_cmd ..
--         body_cmd ..
--         ' "' .. url .. '"'

--     -- Thực thi
--     local result = execute(cmd)

--     -- Bắt lỗi
--     if not result or result == "" then
--         log("⚠️ Không có phản hồi (rỗng)")
--         return false
--     end

--     if result:match("curl:") or result:match("timeout:") then
--         log("⚠️ Curl báo lỗi hoặc timeout: " .. result)
--         return false
--     end

--     log("📩 Kết quả POST: " .. result)
--     return result
-- end




function clean(str)
    if not str then return "" end
    -- Xoá BOM UTF-8 và ký tự lạ đầu chuỗi
    str = str:gsub("^\239\187\191", "")
    str = str:gsub("^[^%{]*", "")
    return str
end


-- Lấy mail icloud từ server ------------------------------------------------------------------------------------------------------------------------

function trim(s)
    return (s:gsub("^%s*(.-)%s*$", "%1"))
end

function LoadEmail()
    local retryDecode = 0
    ::start::
    local url = "http://107.178.103.196/Tool/Facebook/LayMail.php"
    -- local result = HTTPGet4({["content-type"] = "application/json"}, url)
    local result = SendRequest(url)
    if not result or result == "" then
        retryDecode = retryDecode + 1
        log("Không có phản hồi từ máy chủ đợi, 10s")
        if retryDecode >= 10 then
            log("Máy chủ không có phản hồi hoặc hết mail ")
            return false
        end
        usleep(10000000)
        goto start
    end

    result = clean(result)
    local ok, ketqua = pcall(function() return json.decode(result) end)
    if not ok or not ketqua or not ketqua.status then
        retryDecode = retryDecode + 1
        log("JSON decode lỗi, retry...")
        if retryDecode >= 10 then
            log("JSON decode lỗi quá 10 lần hoặc hết mail")
            return false
        end
        usleep(10000000)
        goto start
    end
    retryDecode = 0
    if ketqua.status ~= "ok" then
        log("API trả về lỗi, retry...")
        usleep(1000000)
        goto start
    end

    local email_raw = ketqua.data or ""
    local profile = ketqua.profile or ""

    -- 🧩 Tách chỉ phần email (bỏ phần sau dấu "|")
    local email = email_raw:match("([^|]+)") or email_raw
    email = trim(email)

    if email == "" then
        log("Không có email, retry...")
        usleep(1000000)
        goto start
    end

    -- GHI LẠI FILE: email\nprofile
    local new_content = email_raw .. "\n" .. profile
    writeFileString("/MailReg.lua", new_content)

    log("📧 Lấy email: " .. email)
    log("🧩 Profile: " .. profile)
    return email
end




-- Get opt từ sever IMAP  ------------------------------------------------------------------------------------------------------------------------

function GetOpt()
    -- Đọc email từ file
    local content = readFileString("/MailReg.lua")
    local email = ""
    if content and content ~= "" then
        -- Lấy dòng đầu tiên (bỏ qua các dòng sau)
        email = (content:match("([^\r\n]+)") or ""):match("([^|]+)") or ""
        email = trim(email)  -- thêm trim để an toàn
    end
    usleep(1000000)
    log("Day là getotp của mail" .. email)
    if not email then
        log("❌ Không tìm thấy email")
        return false
    end
    local base_url = "http://107.178.103.196:5002/api/check?from=registration&to="
    local encoded_email = url_encode2(email)
    local full_url = base_url..encoded_email
    log(full_url)
    log("⏳ Checking OPT cho: " .. email)
    -- Thử lại tối đa 2 lần nếu lỗi mạng
    for attempt = 1, 2 do
        toast("Chờ mã OTP")
        local result = SendRequest(full_url)
        if result then  -- Thêm check nil để tránh lỗi khi clean/parse
            result = clean(result)
            log("📩 Response (attempt " .. attempt .. "): " .. tostring(result))
            if result ~= "" and not string.match(result, "Error") then
                local success, data = pcall(function() return json.decode(result) end)
                usleep(200000)
                if success and data and type(data) == "table" and data.count and data.count > 0 then
                    usleep(200000)
                    local email_info = data.emails and data.emails[1]
                    if email_info then
                        usleep(200000)
                        local otp_code = email_info.otp
                        -- Nếu không có trường otp, tìm trong subject/body
                        if (not otp_code or otp_code == "") then
                            usleep(200000)
                            if email_info.subject then
                                usleep(200000)
                                otp_code = string.match(email_info.subject, "%d%d%d%d%d")
                            end
                            if (not otp_code or otp_code == "") and email_info.body then
                                usleep(200000)
                                otp_code = string.match(email_info.body, "%d%d%d%d%d")
                            end
                        end
                        if otp_code and otp_code ~= "" then
                            usleep(200000)
                            log("✅ Lấy OTP thành công: " .. otp_code .. " cho email " .. email)
                            writeFileString("/OptCode.lua", otp_code)
                            return true, otp_code
                        else
                            log("❌ Không tìm thấy mã OTP trong dữ liệu email")
                        end
                    else
                        log("❌ Không có trường 'emails[1]' trong JSON")
                    end
                else
                    log("❌ Parse JSON lỗi hoặc không có email mới")
                end
            end
        else
            log("⚠️ Timeout hoặc lỗi kết nối (attempt " .. attempt .. "), thử lại sau 2s...")
            usleep(2000000)
        end
    end
    log("❌ GetOpt thất bại sau 2 lần thử cho email: " .. email)
    return false
end

function GetOptsecurity()
    -- Đọc email từ file
    local content = readFileString("/MailReg.lua")
    local email = ""
    if content and content ~= "" then
        -- Lấy dòng đầu tiên (bỏ qua các dòng sau)
        email = (content:match("([^\r\n]+)") or ""):match("([^|]+)") or ""
        email = trim(email)  -- thêm trim để an toàn
    end
    usleep(1000000)
    log("Day là getotp của mail" .. email)
    if not email then
        log("❌ Không tìm thấy email")
        return false
    end
    -- local base_url = "http://107.178.103.196:5000/api/check?from=registration&to="
    local base_url = "http://107.178.103.196:5000/api/check?from=security&to="
    local encoded_email = url_encode2(email)
    local full_url = base_url..encoded_email
    log("⏳ Checking OPT cho: " .. email)
    -- Thử lại tối đa 2 lần nếu lỗi mạng
    for attempt = 1, 2 do
        toast("Chờ mã OTP")
        local result = SendRequest(full_url)
        if result then  -- Thêm check nil để tránh lỗi khi clean/parse
            result = clean(result)
            log("📩 Response (attempt " .. attempt .. "): " .. tostring(result))
            if result ~= "" and not string.match(result, "Error") then
                local success, data = pcall(function() return json.decode(result) end)
                usleep(200000)
                if success and data and type(data) == "table" and data.count and data.count > 0 then
                    usleep(200000)
                    local email_info = data.emails and data.emails[1]
                    if email_info then
                        usleep(200000)
                        local otp_code = email_info.otp
                        -- Nếu không có trường otp, tìm trong subject/body
                        if (not otp_code or otp_code == "") then
                            usleep(200000)
                            if email_info.subject then
                                usleep(200000)
                                otp_code = string.match(email_info.subject, "%d%d%d%d%d")
                            end
                            if (not otp_code or otp_code == "") and email_info.body then
                                usleep(200000)
                                otp_code = string.match(email_info.body, "%d%d%d%d%d")
                            end
                        end
                        if otp_code and otp_code ~= "" then
                            usleep(200000)
                            log("✅ Lấy OTP thành công: " .. otp_code .. " cho email " .. email)
                            return true, otp_code
                        else
                            log("❌ Không tìm thấy mã OTP trong dữ liệu email")
                        end
                    else
                        log("❌ Không có trường 'emails[1]' trong JSON")
                    end
                else
                    log("❌ Parse JSON lỗi hoặc không có email mới")
                end
            end
        else
            log("⚠️ Timeout hoặc lỗi kết nối (attempt " .. attempt .. "), thử lại sau 2s...")
            usleep(2000000)
        end
    end
    log("❌ GetOpt thất bại sau 2 lần thử cho email: " .. email)
    return false
end

local function isKeySaved(filePath, newKey)
    local file = io.open(filePath, "r")
    if file then
        local savedKey = file:read("*all")
        file:close()
        return savedKey == newKey
    end
    return false
end

-- Get mã 2fa ------------------------------------------------------------------------------------------------------------------------

function get2FACodeFromFile()
    local secret = readFileString("/2Fa.lua")  -- Đọc toàn bộ file

    if not secret or secret == "" then
        log("❌ Không tìm thấy hoặc file /2Fa.lua rỗng")
        return nil
    end

    secret = secret:gsub("%s+", "") -- Loại bỏ khoảng trắng, xuống dòng
    log("🔑 Secret key: " .. secret)

    -- Gọi HTTPGet4 để lấy code 2FA
    local url = "https://2fa.live/tok/" .. secret
    local headers = { "User-Agent: Mozilla/5.0" }

    local response = SendRequest(url)

    if response then
        -- Parse code 2FA (response JSON: {"token":"123456"} hoặc {"code":"123456"})
        local code = string.match(response, '"code"%s*:%s*"(%d%d%d%d%d%d)"')
                      or string.match(response, '"token"%s*:%s*"(%d%d%d%d%d%d)"')

        if code then
            log("✅ Code 2FA: " .. code)
            return code
        else
            log("⚠️ Không parse được code từ response: " .. response)
            return nil
        end
    else
        log("❌ Lỗi khi gọi 2fa.live")
        return nil
    end
end

-- Check hotmail ------------------------------------------------------------------------------------------------------------------------
function CheckLiveHotmail()
    ::start::
    local json = require "json"
    local url = "https://login.microsoftonline.com/common/oauth2/v2.0/token"
    local headers = {
        ["Content-Type"] = "application/x-www-form-urlencoded"
    }

    local token = readFileString("/Hotmail.lua")
    toast("🔄 Đang đọc file thông tin...")

    if not token then
        log("❌ Không thể đọc file MailRegTF")
        return false
    end

    local parts = {}
    for part in string.gmatch(token, "([^|]+)") do
        table.insert(parts, part)
    end

    if #parts < 4 then
        log("❌ Dữ liệu email không hợp lệ")
        return false
    end

    local refresh_token = parts[3]
    local client_id = parts[4]

    -- ⚙️ Dữ liệu cần POST (form-urlencoded, không phải JSON)
    local body =
        "client_id=".. client_id ..
        "&grant_type=refresh_token" ..
        "&refresh_token=" .. refresh_token ..
        "&redirect_uri=https://login.microsoftonline.com/common/oauth2/nativeclient" ..
        "&scope=https://graph.microsoft.com/.default"

    log("🚀 Đang gửi yêu cầu lấy Access Token...")

    local response = HTTPPost4(headers, url, body)

    if not response or response == "" then
        log("❌ Không có phản hồi từ máy chủ")
        goto start
    end

    log("📩 Phản hồi từ server: " .. response)

    local ok, data = pcall(json.decode, response)
    if ok and data and data.access_token then
        log("✅ Lấy token thành công!")
        return true
    else
        log("⚠️ Lỗi khi lấy token: " .. (data and (data.error_description or data.error) or "Không xác định"))
        return false
    end
end


function BuyMail()
    local json = require "json"
    while true do
        log("🛒 Đang mua Hotmail mới...")
        -- 🟢 API lấy mail từ server của bạn
        local url = "http://107.178.103.196/Tool/Facebook/AcReg.php"
        local headers = { "Content-Type: application/json" }

        local response = SendRequest(url)
        if not response or response == "" then
            log("⚠️ Không thể kết nối API, thử lại sau 5s...")
            usleep(5000000)
        else
            response = string.gsub(response, "^\239\187\191", "")
            local success, data = pcall(json.decode, response)
            if not success or not data or data.status ~= "ok" or not data.data then
                log("⚠️ API trả về lỗi hoặc dữ liệu không hợp lệ: " .. tostring(response))
                usleep(5000000)
            else
                local account_data = data.data
                if not account_data or account_data == "" then
                    log("⚠️ Không có dữ liệu tài khoản, thử lại...")
                    usleep(3000000)
                else
                    -- 📝 Lưu mail mới vào file để CheckLiveHotmail xử lý
                    local ok, err = pcall(function()
                        writeFileString("/Hotmail.lua", account_data)
                    end)

                    if not ok then
                        log("⚠️ Lỗi ghi file: " .. tostring(err))
                        usleep(3000000)
                    else
                        log("📝 Đã lưu dữ liệu vào /Hotmail.lua")
                        log("🔍 Kiểm tra mail vừa mua...")

                        local live = CheckLiveHotmail()
                        if live then
                            local email = string.match(account_data, "^[^|]+") or account_data
                            log("🎉 Mail sống: " .. email)

                            -- 🔒 Ghi lại mail sống để lưu lịch sử
                            local file = io.open("/MailLive.txt", "a")
                            if file then
                                file:write(email .. "\n")
                                file:close()
                            end

                            return email
                        else
                            log("🗑️ Mail chết, xóa file và mua lại...")
                            os.remove("/Hotmail.lua")
                            usleep(3000000)
                        end
                    end
                end
            end
        end
    end
end





-- Get OPT FB ------------------------------------------------------------------------------------------------------------------------



function GetOTPFB()
    toast("Chờ lấy mã hotmail")
    local email = readFileString("/Hotmail.lua")
    if not email or email == "" then
        log("Không tìm thấy email trong Hotmail.lua")
        return false
    end

    email = trim(email)
    log("Email kiểm tra OTP FB: " .. email)

    local base_url = "http://107.178.103.196:1000/Tool/?dataemail="
    local encoded_email = url_encode2(email)
    local full_url = base_url .. encoded_email

    local function clean_json(str)
        if not str then return "" end
        -- Xóa BOM + control chars + trim
        local bom = str:match("^[\239][187][191]?()")
        if bom then str = str:sub(bom) end
        str = str:gsub("[\000-\031\127]", "")
        str = str:gsub("^%s+", ""):gsub("%s+$", "")
        return str
    end

    local function extract_otp(text)
        if not text or text == "" then return nil end
        return string.match(text, "%d%d%d%d%d%d")   -- 6 số (Facebook thường dùng 6)
            or string.match(text, "%d%d%d%d%d%d%d") -- 7 số
            or string.match(text, "%d%d%d%d%d")     -- 5 số
            or string.match(text, "%d%d%d%d")       -- 4 số
    end

    local function is_facebook_email(mail)
        if not mail then return false end
        local from = (mail.from or ""):lower()
        local subject = (mail.subject or ""):lower()
        return from:find("facebook") or from:find("meta") or from:find("fb") 
            or subject:find("facebook") or subject:find("confirm this email") 
            or subject:find("your code")
    end

    for attempt = 1, 3 do
        local result = SendRequest(full_url)
        result = clean_json(result)
        log("Response (attempt " .. attempt .. "): " .. tostring(result))

        if result ~= "" and not result:find("Error") then
            local ok, data = pcall(json.decode, result)
            if ok and data and type(data) == "table" then

                -- Duyệt từng email trong danh sách
                for _, mail in ipairs(data) do
                    if is_facebook_email(mail) then
                        local otp = extract_otp(mail.subject) or extract_otp(mail.body)
                        if otp then
                            log("Lấy OTP Facebook thành công: " .. otp)
                            writeFileString("/OptCodeFB.lua", otp)
                            return otp
                        end
                    end
                end

                -- Fallback: tìm trong toàn bộ text nếu không thấy
                local fallback_otp = extract_otp(result)
                if fallback_otp and result:lower():find("facebook") then
                    log("Lấy OTP Facebook từ fallback: " .. fallback_otp)
                    writeFileString("/OptCodeFB.lua", fallback_otp)
                    return fallback_otp
                end
            else
                log("JSON decode lỗi")
            end
        else
            log("Phản hồi rỗng, thử lại sau 2s...")
            usleep(2000000)
        end
    end

    log("GetOTPFB thất bại sau 3 lần thử")
    return nil
end


-- Lưu acc khi xog ------------------------------------------------------------------------------------------------------------------------

function SaveAc()
    ::lai::
    -- Đọc dòng đầu tiên (email) trong file Hotmail.lua
    local hotmail_data = readFileString("/Hotmail.lua")
    if not hotmail_data or hotmail_data == "" then
        log("⚠️ Không tìm thấy file Hotmail.lua hoặc file rỗng")
        usleep(1000000)
        goto lai
    end

    -- Cắt dòng đầu tiên làm email
    local email = hotmail_data:match("([^\n]+)")
    if not email or email == "" then
        log("⚠️ Không tìm thấy email trong file Hotmail.lua")
        usleep(1000000)
        goto lai
    end

    local secret = readFileString("/2Fa.lua")  -- Đọc toàn bộ file

    if not secret or secret == "" then
        log("❌ Không tìm thấy hoặc file /2Fa.lua rỗng")
        return nil
    end

    secret = secret:gsub("%s+", "") -- Loại bỏ khoảng trắng, xuống dòng
    log("🔑 Secret key: " .. secret)
    
    toast("Đang Đẩy Ac")

    local timeInUTC7 = getTimeInHoChiMinh()
    local encoded_time = url_encode2(timeInUTC7)
    local AcXong = email .. "|" .. "Zxcv123123!!" .. "|" ..secret.."|".. encoded_time

    local data = "http://107.178.103.196/tool/Facebook/DataXong.php?text=" .. AcXong
    local result = SendRequest(data)
    
    local found = string.match(result or "", "[Oo][Kk]")
    if found then
        log("✅ OK — Đẩy tài khoản thành công")
        return
    else
        usleep(1000000)
        goto lai
    end
end

function SaveAcLive(data1)
    ::lai::
    toast("Đang Đẩy Ac")
    local may_content = readFileString("/may.lua")
    if not may_content or may_content == "" then
        log("Không đọc được /may.lua")
        return false
    end
    local may_line = may_content:match("([^\r\n]+)") or ""
    local may_line = trim(may_line)
    local timeInUTC7 = getTimeInHoChiMinh()
    local encoded_time = url_encode2(timeInUTC7)
    local AcXong = data1 .."|".. may_line .."|".. encoded_time

    local data = "http://107.178.103.196/tool/Facebook/DataXong.php?text=" .. AcXong
    local result = SendRequest(data)
    
    local found = string.match(result or "", "[Oo][Kk]")
    if found then
        log("✅ OK — Đẩy tài khoản thành công")
        return
    else
        usleep(1000000)
        goto lai
    end
end

function SaveAcChuaXong(data1)
    ::lai::
    toast("Đang Đẩy Ac")
    local may_content = readFileString("/may.lua")
    if not may_content or may_content == "" then
        log("Không đọc được /may.lua")
        return false
    end
    local may_line = may_content:match("([^\r\n]+)") or ""
    may_line = trim(may_line)
    local timeInUTC7 = getTimeInHoChiMinh()
    local encoded_time = url_encode2(timeInUTC7)
    local AcXong = data1 .."|".. trangthai.."|".. may_line .. "|".. encoded_time

    local data = "http://107.178.103.196/tool/Facebook/DataChuaXong.php?text=" .. AcXong
    local result = SendRequest(data)
    
    local found = string.match(result or "", "[Oo][Kk]")
    if found then
        log("✅ OK — Đẩy tài khoản thành công")
        return
    else
        usleep(1000000)
        goto lai
    end
end


function SaveAcChuaHotmail(data1)
    ::lai::
    toast("Đang Đẩy Ac")
    local may_content = readFileString("/may.lua")
    if not may_content or may_content == "" then
        log("Không đọc được /may.lua")
        return false
    end
    local may_line = may_content:match("([^\r\n]+)") or ""
    local timeInUTC7 = getTimeInHoChiMinh()
    may_line = trim(may_line)
    local encoded_time = url_encode2(timeInUTC7)
    local AcXong = data1 .."|".. may_line .."|".. encoded_time

    local data = "http://107.178.103.196/tool/Facebook/DataChuaHotmail.php?text=" .. AcXong
    local result = SendRequest(data)
    
    local found = string.match(result or "", "[Oo][Kk]")
    if found then
        log("✅ OK — Đẩy tài khoản thành công")
        return
    else
        usleep(1000000)
        goto lai
    end
end


-- function request_plain(post_body, link)
--     local curl = require("cURL")
--     local easy = curl.easy()
--     local headers = {
--         "Content-Type: text/plain",
--         "Content-Length: " .. tostring(#post_body)
--     }

--     easy:setopt_url(link)
--     easy:setopt_ssl_verifypeer(false)
--     easy:setopt_ssl_verifyhost(0)
--     easy:setopt_httpheader(headers)
--     easy:setopt_post(true)
--     easy:setopt_postfields(post_body)

--     local response = {}

--     easy:setopt_writefunction(function(data)
--         table.insert(response, data)
--         return #data
--     end)

--     local ok, err = pcall(function()
--         easy:perform()
--     end)

--     easy:close()

--     if not ok then
--         return nil, err
--     end

--     return table.concat(response)
-- end


function request_plain(post_body, url)
    -- escape ký tự "
    local safe_body = post_body:gsub('"', '\\"')

    -- dùng echo + pipe → GỬI TRỰC TIẾP vào curl
    local cmd = string.format(
        'echo "%s" | curl -s -X POST -H "Content-Type: text/plain" --data-binary @- "%s"',
        safe_body, url
    )

    local res = execute(cmd)

    if not res or res == "" then
        return nil, "Không có phản hồi từ server"
    end

    return res, nil
end

function ReadCookie()
    local SERVER_IP = "107.178.103.196"
    local SERVER_PORT = 6000
    local DEVICE_NAME = "iPhone8"
    local COOKIE_PATH = GetInfoApp()
    if COOKIE_PATH ~= false then
        local function read_binary(path)
            local f = io.open(path, "rb")
            if not f then
                print("❌ Không mở được file:", path)
                return nil
            end
            local data = f:read("*a")
            f:close()
            return data
        end


        local function write_text(path, text)
            local f = io.open(path, "w")
            if not f then
                print("❌ Không ghi được file:", path)
                return false
            end
            f:write(text)
            f:close()
            return true
        end

        local b = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
        local function base64_encode(data)
            return ((data:gsub('.', function(x)
                local r, byte = '', x:byte()
                for i = 8, 1, -1 do
                    r = r .. (byte % 2 ^ i - byte % 2 ^ (i - 1) > 0 and '1' or '0')
                end
                return r
            end) .. '0000'):gsub('%d%d%d?%d?%d?%d?', function(x)
                if #x < 6 then return '' end
                local c = 0
                for i = 1, 6 do
                    c = c + (x:sub(i, i) == '1' and 2 ^ (6 - i) or 0)
                end
                return b:sub(c + 1, c + 1)
            end) .. ({ '', '==', '=' })[#data % 3 + 1])
        end

        local function send_cookie(server_ip, port, device_name, base64_data)
        local url = string.format(
            "http://%s:%d/upload_cookie_base64?device=%s",
            server_ip, port, device_name
        )

        local res, err = request_plain(base64_data, url)

        if not res then
            print("❌ Request lỗi:", err)
            return nil
        end

        return res
    end


        local cookie_data = read_binary(COOKIE_PATH)
        if not cookie_data then
            print("⚠️ Không đọc được file cookie, thoát.")
            return
        end

        local base64_data = base64_encode(cookie_data)
        local response = send_cookie(SERVER_IP, SERVER_PORT, DEVICE_NAME, base64_data)
        print("📩 Phản hồi từ server:")
        print(response or "❌ Không có phản hồi từ server.")
        return response
    else
        log("chưa có cookie")
        return false
    end
end

-- Hàm đổi proxy theo API
function ChangeProxy()
    -- 1. đọc dòng đầu tiên trong Proxy.lua
    local proxy = readFileString("/Proxy.lua")
    if not proxy or proxy == "" then
        log("❌ Không đọc được Proxy.lua")
        return nil
    end

    -- lấy dòng đầu tiên
    local firstLine = proxy:match("([^\r\n]+)")
    if not firstLine then
        log("❌ Proxy.lua không có dòng hợp lệ")
        return nil
    end

    -- 2. tách host và port
    local host, port = firstLine:match("^(.-):(%d+)$")
    if not host or not port then
        log("❌ Không tách được host và port từ: " .. firstLine)
        return nil
    end

    -- 3. tạo URL API
    local url = "http://103.163.24.67:8081/change-proxy?port="..port.."&time=300"
    SendRequest(url)
    return true
end

function SwitchProxyWithModel(model)
    -- 1. Kiểm tra model hợp lệ
    if not model or (model ~= "main" and model ~= "sub") then
        log("❌ Model phải là 'main' hoặc 'sub'")
        return nil
    end
    -- 2. Đọc dòng đầu tiên trong Proxy.lua
    local proxy = readFileString("/Proxy.lua")
    if not proxy or proxy == "" then
        log("❌ Không đọc được Proxy.lua")
        return nil
    end
    -- lấy dòng đầu tiên
    local firstLine = proxy:match("([^\r\n]+)")
    if not firstLine then
        log("❌ Proxy.lua không có dòng hợp lệ")
        return nil
    end
    -- 3. tách host và port
    local host, port = firstLine:match("^(.-):(%d+)$")
    if not host or not port then
        log("❌ Không tách được host và port từ: " .. firstLine)
        return nil
    end
    -- 4. Tạo URL API switch proxy
    local url = "http://103.163.24.67:8081/switch-proxy/" .. port .. "?mode=" .. model
    log("🔄 Switching proxy: " .. url)
    -- 5. Gửi request
    SendRequest(url)
    return true
end
----------------- Request IP ------------------------------------------------------------------------------------------------

-- local raw = SendRequestIP("http://ip-api.com/json")

-- if raw then
--     local info = ParseLocation(raw)
--     log(info)
-- end

-- function SendRequestIP(url)
--     local proxy = readFileString("/Proxy.lua")
--     local cmd = string.format(
--         'curl -x %s --connect-timeout 5 --max-time 15 -s "%s"',
--         proxy, url
--     )
--     local result = execute(cmd)

--     if not result or result == "" then
--         log("không có kết quả")
--         return nil
--     end
--     return result
-- end

-- -- Hàm lấy IP|Country|Region
-- function ParseLocation(json_text)
--     local ok, data = pcall(json.decode, json_text)
--     if not ok or not data then
--         log("❌ JSON parse lỗi")
--         return nil
--     end

--     local ip     = data.query or ""
--     local country = data.country or ""
--     local region  = data.region or ""

--     local final = string.format("%s|%s|%s", ip, country, region)
--     return final
-- end

function GetIPInfo()
    -- Đọc proxy
    local proxy = readFileString("/Proxy.lua") or ""

    -- Hàm gửi request với proxy
    local function SendRequestIP(url)
        local cmd = string.format(
            'curl -x %s --connect-timeout 5 --max-time 15 -s "%s"',
            proxy, url
        )
        local result = execute(cmd)

        if not result or result == "" then
            log("❌ Không có dữ liệu trả về từ server IP")
            return nil
        end
        return result
    end

    -- Parse JSON trả về từ ip-api
    local function ParseLocation(json_text)
        local ok, data = pcall(json.decode, json_text)
        if not ok or not data then
            log("❌ JSON parse lỗi (IP API phản hồi sai định dạng)")
            return nil
        end

        local ip      = data.query or ""
        local country = data.country or ""
        local region  = data.regionName or data.region or ""

        return string.format("%s|%s|%s", ip, country, region)
    end

    -- Gửi request
    local raw = SendRequestIP("http://ip-api.com/json")
    if not raw then return nil end

    local info = ParseLocation(raw)
    if info then
        log("🌍 IP Info: " .. info)
    end

    return info
end






function MailTraLai()
    local content = readFileString("/MailReg.lua")
    if not content or content == "" then
        log("Không đọc được /MailReg.lua")
        return false
    end

    local email, count = nil, 0
    local profile = nil

    -- Tách từng dòng
    local lines = {}
    for line in content:gmatch("([^\n]*)\n?") do
        line = trim(line)
        if line ~= "" then
            table.insert(lines, line)
        end
    end

    if #lines < 1 then
        log("File rỗng hoặc không có email")
        return false
    end

    -- DÒNG 1: email hoặc email|count
    local first_line = lines[1]
    email, count_str = first_line:match("([^|]+)|(%d+)")
    if email then
        count = tonumber(count_str) or 0
    else
        -- Không có | → email là cả dòng 1, count = 0
        email = first_line
        count = 0
    end

    -- DÒNG 2: profile (nếu có)
    if #lines >= 2 then
        profile = lines[2]
    end

    if not email or not profile then
        log("Thiếu email hoặc profile trong file")
        return false
    end

    -- Tăng count
    count = count + 1

    -- GỌI API: text=email|count
    local url = "http://107.178.103.196/Tool/Facebook/mail/" .. profile .. "/DataAc.php?text=" .. email .. "|" .. count
    SendRequest(url)

    log("Đã trả mail: " .. email .. "|" .. count .. " (profile: " .. profile .. ")")
    return true
end


function MailXong()
    local content = readFileString("/MailReg.lua")
    if not content or content == "" then
        log("Không đọc được /MailReg.lua")
        return false
    end

    local email, count = nil, 0
    local profile = nil

    -- Tách từng dòng
    local lines = {}
    for line in content:gmatch("([^\n]*)\n?") do
        line = trim(line)
        if line ~= "" then
            table.insert(lines, line)
        end
    end

    if #lines < 1 then
        log("File rỗng hoặc không có email")
        return false
    end

    -- DÒNG 1: email hoặc email|count
    local first_line = lines[1]
    email, count_str = first_line:match("([^|]+)|(%d+)")
    if email then
        count = tonumber(count_str) or 0
    else
        -- Không có | → email là cả dòng 1, count = 0
        email = first_line
        count = 0
    end

    -- DÒNG 2: profile (nếu có)
    if #lines >= 2 then
        profile = lines[2]
    end

    if not email or not profile then
        log("Thiếu email hoặc profile trong file")
        return false
    end

    -- GỌI API: text=email|count
    local url = "http://107.178.103.196/Tool/Facebook/mail/" .. profile .. "/DataAcXong.php?text=" .. email
    SendRequest(url)

    log("Đã trả mail: " .. email .. " (profile: " .. profile .. ")")
    return true
end


function MailNoCreat()
    -- Đọc file /MailReg.lua
    local content = readFileString("/MailReg.lua")
    if not content or content == "" then
        log("Không đọc được /MailReg.lua")
        return false
    end

    -- Lấy dòng đầu tiên
    local line = content:match("([^\r\n]+)") or ""
    line = trim(line)
    if line == "" then
        log("Dòng đầu rỗng hoặc không có email")
        return false
    end

    -- Tách email và số lần
    local email, num = line:match("^(.-)|(%d+)$")

    -- Nếu không có |số → coi như num = 0
    if not email then
        email = line  -- toàn bộ dòng là email
        num = "0"
    end

    -- Chuyển num về số để so sánh
    local n = tonumber(num) or 0

    -- Xử lý theo số lần
    if n > 1 then
        local url = "http://107.178.103.196/Tool/Facebook/DataNoCreat.php?text=" .. email .. "|2"
        SendRequest(url)
        log("Đã đẩy dữ liệu qua API DataNoCreat: " .. email .. "|2")
        return "2lanroi"
    elseif n >= 0 or n <= 1 then
        log("✅ Còn hạn sử dụng: " .. email .. "|" .. num)
        return "conhansudung"
    else
        log("⚠️ Giá trị không xác định: " .. num)
        return "khongxacdinh"
    end
end

function MailNoCrete3LanLienTuc()
    local content = readFileString("/MailReg.lua")
    local may_content = readFileString("/may.lua")

    if not content or content == "" then
        log("Không đọc được MailReg.lua")
        return false
    end
    if not may_content or may_content == "" then
        log("Không đọc được may.lua")
        return false
    end

    
    local line = trim(content:match("([^\r\n]+)") or "")
    local may_line = trim(may_content:match("([^\r\n]+)") or "")

    if line == "" then
        log("Dòng đầu rỗng hoặc không có dữ liệu")
        return false
    end

    -- ghép dữ liệu cần gửi
    local payload = string.format("%s|%s", line, may_line)
    local encoded = url_encode(payload)

    local url = "http://107.178.103.196/Tool/Facebook/DataNoCreat.php?text=" .. encoded .. "|3lanlientiep"

    local res = SendRequest(url)
    if not res then
        log("❌ API không có kết quả")
    end
    return true
end


function url_encode(str)
    if not str then return "" end
    str = tostring(str)
    str = str:gsub("\n", "\r\n")
    str = str:gsub("([^%w%-_%.~])", function(c)
        return string.format("%%%02X", string.byte(c))
    end)
    return str
end

function CheckMailNoCrete()
    local content = readFileString("/MailReg.lua")
    local may_content = readFileString("/may.lua")

    if not content or content == "" then
        log("Không đọc được MailReg.lua")
        return false
    end
    if not may_content or may_content == "" then
        log("Không đọc được may.lua")
        return false
    end

    local Ipstart = GetIPInfo() or ""
    local line = trim(content:match("([^\r\n]+)") or "")
    local may_line = trim(may_content:match("([^\r\n]+)") or "")

    if line == "" then
        log("Dòng đầu rỗng hoặc không có dữ liệu")
        return false
    end

    -- ghép dữ liệu cần gửi
    local payload = string.format("%s|%s|%s", line, may_line, Ipstart)
    local encoded = url_encode(payload)

    local url = "http://107.178.103.196/Tool/Facebook/CheckDataNoCreat.php?text=" .. encoded

    local res = SendRequest(url)
    if not res then
        log("❌ API không có kết quả")
    end
    return true
end

function IpStart()
    local may_content = readFileString("/may.lua")
     local timeInUTC7 = getTimeInHoChiMinh()
    local encoded_time = url_encode2(timeInUTC7)
    if not may_content or may_content == "" then
        log("Không đọc được may.lua")
        return false
    end
    local Ipstart = GetIPInfo() or ""
    local may_line = trim(may_content:match("([^\r\n]+)") or "")
    -- ghép dữ liệu cần gửi
    local payload = string.format("%s|%s", may_line, Ipstart)
    local encoded = url_encode(payload)
    local url = "http://107.178.103.196/Tool/Facebook/IpBatdau.php?text=" .. encoded .. "|".. encoded_time .. "|Batdau" 
    local res = SendRequest(url)
    if not res then
        log("❌ API không có kết quả")
    end
    return true
end

function IpCheckPass()
    local content = readFileString("/MailReg.lua")
    local may_content = readFileString("/may.lua")
    local timeInUTC7 = getTimeInHoChiMinh()
    local encoded_time = url_encode2(timeInUTC7)
    if not content or content == "" then
        log("Không đọc được MailReg.lua")
        return false
    end
    if not may_content or may_content == "" then
        log("Không đọc được may.lua")
        return false
    end
    local Ipstart = GetIPInfo() or ""
    local line = trim(content:match("([^\r\n]+)") or "")
    local may_line = trim(may_content:match("([^\r\n]+)") or "")
    if line == "" then
        log("Dòng đầu rỗng hoặc không có dữ liệu")
        return false
    end
    -- ghép dữ liệu cần gửi
    local payload = string.format("%s|%s|%s", line, may_line, Ipstart)
    local encoded = url_encode(payload)
    local url = "http://107.178.103.196/Tool/Facebook/IpCheck.php?text=" .. encoded .. "|" .. encoded_time .. "|Daqua" 
    local res = SendRequest(url)
    if not res then
        log("❌ API không có kết quả")
    end
    return true
end

function IpCheckChuaqua()
    local content = readFileString("/MailReg.lua")
    local may_content = readFileString("/may.lua")
    local timeInUTC7 = getTimeInHoChiMinh()
    local encoded_time = url_encode2(timeInUTC7)
    if not content or content == "" then
        log("Không đọc được MailReg.lua")
        return false
    end
    if not may_content or may_content == "" then
        log("Không đọc được may.lua")
        return false
    end
    local Ipstart = GetIPInfo() or ""
    local line = trim(content:match("([^\r\n]+)") or "")
    local may_line = trim(may_content:match("([^\r\n]+)") or "")
    if line == "" then
        log("Dòng đầu rỗng hoặc không có dữ liệu")
        return false
    end
    -- ghép dữ liệu cần gửi
    local payload = string.format("%s|%s|%s", line, may_line, Ipstart)
    local encoded = url_encode(payload)
    local url = "http://107.178.103.196/Tool/Facebook/IpCheck.php?text=" .. encoded .. "|" .. encoded_time .. "|Chuaqua" 
    local res = SendRequest(url)
    if not res then
        log("❌ API không có kết quả")
    end
    return true
end

function MailDie()
    -- Đọc file /MailReg.lua
    local content = readFileString("/MailReg.lua")
    local may_content = readFileString("/may.lua")
    local timeInUTC7 = getTimeInHoChiMinh()
    local encoded_time = url_encode2(timeInUTC7)
    if not content or content == "" then
        log("Không đọc được /MailReg.lua")
        return false
    end
    if not may_content or may_content == "" then
        log("Không đọc được /may.lua")
        return false
    end

    -- LẤY DÒNG ĐẦU CỦA TỪNG FILE
    local email_line = content:match("([^\r\n]+)") or ""
    local may_line = may_content:match("([^\r\n]+)") or ""

    email_line = trim(email_line)
    may_line = trim(may_line)

    if email_line == "" or may_line == "" then
        log("Dòng đầu rỗng trong file MailReg hoặc may.lua")
        return false
    end

    -- GỘP: email_line + "|" + may_line
    local text = email_line .. "|" .. may_line .. "|" .. encoded_time

    -- GỌI API
    local url = "http://107.178.103.196/Tool/Facebook/DataMailDie.php?text=" .. text
    SendRequest(url)

    log("Đã gọi API DataMailDie: " .. text)
    return true
end


