function file_exists(file)
  local f = io.open(file, "rb")
  if f then f:close() end
  return f ~= nil
end

function removefile(file)
    while file_exists(file) do
        local result, err = os.remove(file)
        usleep(1000000)
    end
end

function upload_file(file_path, url)
    local f = io.open(file_path, "rb")
    if not f then
        return nil, "Không mở được file: " .. file_path
    end
    f:close()
    local cmd = string.format(
        'curl -s -X POST -F "file=@%s" "%s"',
        file_path, url
    )

    local result = execute(cmd)
    if result == nil or result == "" then
        return nil, "Không có phản hồi từ server"
    end

    return result, nil
end

local dir = rootDir()
log(dir)
local zip_file = dir .. "/Tool.zip"

-- Danh sách file cần loại bỏ khi nén
local exclude = {
    ["UpdateTool.lua"] = true,
    ["tesst.lua"] = true,
    ["test1.lua"] = true,
    ["test2.lua"] = true,
    ["ProxyFB.lua"] = true,
    ["OptCodeFB.lua"] = true,
    ["OptCode.lua"] = true,
    ["MailReg.lua"] = true,
    ["Hotmail.lua"] = true,
    ["Start.lua"] = true,
    ["2Fa.lua"] = true,
    ["Dungman.lua"] = true,
    ["Proxy.lua"] = true,
    ["may.lua"] = true,

}

os.remove(zip_file)

local result = execute('ls -l "' .. dir .. '"')
local files_to_zip = {}
for line in string.gmatch(result, "[^\r\n]+") do
    -- Bỏ dòng directory
    if string.sub(line, 1, 1) ~= "d" then
        local filename = line:match("%S+$")
        if filename and not exclude[filename] then
            table.insert(files_to_zip, dir .. "/" .. filename)
        end
    end
end
if #files_to_zip == 0 then
    alert("Không có file nào để nén!")
    return
end
local cmd = 'zip -j "' .. zip_file .. '"'
for _, filepath in ipairs(files_to_zip) do
    cmd = cmd .. ' "' .. filepath .. '"'
end

local zip_result = execute(cmd)
log(zip_result)

while not file_exists(zip_file) do
    usleep(500000)
end


local res, err = upload_file(zip_file, "http://107.178.103.196/Tool/Facebook/Code/Upload.php")
if err then
    log("Lỗi: " .. err)
else
    log("Server trả về: " .. res)
end

removefile(zip_file)
